{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:18:48 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMSystem,
  MMObj,
  MMDIBCv,
  MMSpectr,
  MMLight,
  MMDSPObj,
  MMWavIn,
  MMConect,
  MMDesign,
  MMWavOut,
  MMWave,
  MMCstDlg,
  MMSlider,
  MMLEDS,
  MMHook;

type
  TForm1 = class(TForm)
    MMWaveIn1: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMDesigner1: TMMDesigner;
    MMWaveFile1: TMMWaveFile;
    MMWaveOut1: TMMWaveOut;
    MMConnector2: TMMConnector;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    Panel2: TPanel;
    MMLight1: TMMLight;
    Panel3: TPanel;
    Panel4: TPanel;
    RecBtn: TButton;
    PlayBtn: TButton;
    StopBtn: TButton;
    SetupBtn: TButton;
    PopupMenu1: TPopupMenu;
    Sphere1: TMenuItem;
    Circles1: TMenuItem;
    N1: TMenuItem;
    Triangle1: TMenuItem;
    Line1: TMenuItem;
    slMaster: TMMSlider;
    slBass: TMMSlider;
    slMiddle: TMMSlider;
    slTreble: TMMSlider;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MMLED1: TMMLED;
    Label5: TLabel;
    procedure RecBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure SetupBtnClick(Sender: TObject);
    procedure Circles1Click(Sender: TObject);
    procedure Line1Click(Sender: TObject);
    procedure SliderChange(Sender: TObject);
    procedure MMLight1PcmOverflow(Sender: TObject);
    procedure ConnectorTrigger(Sender: TObject);
  private
    function  SelectFile: Boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.RecBtnClick(Sender: TObject);
begin
   MMWaveIn1.Start;
   PlayBtn.Enabled  := False;
   RecBtn.Enabled   := False;
   StopBtn.Enabled  := True;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.StopBtnClick(Sender: TObject);
begin
   MMWaveIn1.Close;
   MMWaveOut1.Close;
   RecBtn.Enabled := True;
   PlayBtn.Enabled  := True;
   StopBtn.Enabled  := False;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.PlayBtnClick(Sender: TObject);
begin
   if (MMWaveFile1.Wave.FileName = '') and not SelectFile then Exit;

   MMWaveOut1.Start;
   PlayBtn.Enabled  := False;
   RecBtn.Enabled   := False;
   StopBtn.Enabled  := True;
end;

{-- TForm1 --------------------------------------------------------------}
function TForm1.SelectFile: Boolean;
begin
   Result := MMWaveOpenDialog1.Execute;
   if Result then
      MMWaveFile1.Wave.FileName := MMWaveOpenDialog1.FileName;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   StopBtnClick(StopBtn);
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormShow(Sender: TObject);
begin
   Caption := Application.Title;
   slMaster.Position := MMLight1.AmplitudeScale;
   slBass.Position := MMLight1.GainBass;
   slMiddle.Position := MMLight1.GainMiddle;
   slTreble.Position := MMLight1.GainTreble;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.SetupBtnClick(Sender: TObject);
var
   P: TPoint;
begin
   P := SetupBtn.ClientToScreen(Point(0,SetupBtn.Height));
   PopupMenu1.Popup(P.X,P.Y);
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.Circles1Click(Sender: TObject);
begin
   if Sender = Circles1 then
      MMLight1.Kind := lkCircle
   else
      MMLight1.Kind := lkSphere;

    Circles1.Checked := MMLight1.Kind = lkCircle;
    Sphere1.Checked  := not Circles1.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.Line1Click(Sender: TObject);
begin
   if Sender = Line1 then
      MMLight1.Arrange := laLine
    else
      MMLight1.Arrange := laTriangle;

    Line1.Checked       := MMLight1.Arrange = laLine;
    Triangle1.Checked   := not Line1.Checked;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.SliderChange(Sender: TObject);
begin
   if (Sender = slMaster) then
      MMLight1.AmplitudeScale := slMaster.Position
   else if (Sender = slBass) then
      MMLight1.GainBass := slBass.Position
   else if (Sender = slMiddle) then
      MMLight1.GainMiddle := slMiddle.Position
   else if (Sender = slTreble) then
      MMLight1.GainTreble := slTreble.Position;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.MMLight1PcmOverflow(Sender: TObject);
begin
   // PCM overflow occured, decrease volume
   MMLED1.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.ConnectorTrigger(Sender: TObject);
begin
   // we only use the event to reset the LED
   MMLED1.Enabled := False;
end;

end.
